/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.configurations.processor;

import com.aptana.configurations.ConfigurationsPlugin;
import com.aptana.configurations.ConfigurationsUtil;
import com.aptana.configurations.processor.AbstractConfigurationProcessor;
import com.aptana.configurations.processor.IConfigurationProcessorDelegate;
import com.aptana.core.ShellExecutable;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ProcessUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProcessorDelegate
implements IConfigurationProcessorDelegate {
    protected Map<String, String> supportedCommands = new HashMap<String, String>(5);
    protected Expression enablementExpression;

    @Override
    public Set<String> getSupportedCommands() {
        return Collections.unmodifiableSet(this.supportedCommands.keySet());
    }

    @Override
    public void setEnablement(Expression enablementExpression) {
        this.enablementExpression = enablementExpression;
    }

    @Override
    public boolean isEnabled() {
        return ConfigurationsUtil.evaluateEnablement(this.enablementExpression);
    }

    @Override
    public Object runCommand(String commandType, IPath workingDir) {
        if (!this.isEnabled()) {
            throw new IllegalStateException("Command not enabled - " + commandType);
        }
        String command = this.supportedCommands.get(commandType);
        if (command == null) {
            throw new IllegalArgumentException("Command not supported - " + commandType);
        }
        String shellCommandPath = this.getShellPath();
        if (shellCommandPath == null) {
            throw new IllegalArgumentException("Shell command path is null");
        }
        String versionOutput = null;
        try {
            versionOutput = ProcessUtil.outputForProcess((Process)ShellExecutable.run((String)this.getSupportedApplication(), (IPath)workingDir, null, (String[])new String[]{command}));
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)ConfigurationsPlugin.getDefault(), (Throwable)e, null);
        }
        return versionOutput;
    }

    protected String getShellPath() {
        String shellCommandPath = AbstractConfigurationProcessor.getShellPath();
        if (shellCommandPath == null) {
            if ("win32".equals(Platform.getOS())) {
                shellCommandPath = "cmd";
            } else {
                throw new IllegalArgumentException("Could not locate a shell to run the command");
            }
        }
        return shellCommandPath;
    }

    @Override
    public abstract String getSupportedApplication();
}

